import { View, StyleSheet, FlatList } from "react-native";
import React from "react";
import BackNavigation from "../../../../Utilities/CustomHeader/BackNavigation";
import ReviewImages from "./ReviewImages";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import useLangTranslation from "../../../../../hooks/useLangTranslation";

const ReviewImageGallery = (props) => {
    const { trans } = useLangTranslation();
    const reviewImageGalleryStyle = ReviewImageGalleryStyle();
    const { images } = props?.route?.params;
    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("Customer Gallery")}
                capitalize={true}
            />
            <View style={reviewImageGalleryStyle.cont}>
                <FlatList
                    data={images}
                    keyExtractor={(_, index) => "key" + index}
                    renderItem={({ item, index }) => (
                        <ReviewImages
                            image={item}
                            index={index}
                            data={images}
                            imageStyle={reviewImageGalleryStyle.image}
                        />
                    )}
                    horizontal={false}
                    numColumns={3}
                    columnWrapperStyle={reviewImageGalleryStyle.columnWrapper}
                />
            </View>
        </>
    );
};

export default ReviewImageGallery;

const imageSize = (dpr("wf") - dpr(60)) / 3;
const ReviewImageGalleryStyle = () =>
    StyleSheet.create({
        cont: {
            flex: 1,
            backgroundColor: "#FFF",
            paddingHorizontal: dpr(20),
        },
        image: {
            height: imageSize,
            width: imageSize,
            marginRight: dpr(10),
            borderRadius: 4,
            borderWidth: 1,
            borderColor: "#F3F3F3",
            marginBottom: dpr(10),
        },
        columnWrapper: {
            justifyContent: "flex-start",
        }
    });
